import yaml
from dataclasses import dataclass

@dataclass
class StudyConfig:
    study_id: str
    size_rule: str
    sizes_csv: str
    mode: str
    alphaP: float
    UGM_phys_m: float
    R_obs_m: float
    c_ms: float
    lambda_G_default: float
    J_m2: float
    dvdr_max_kms_per_kpc: float
    min_window_points: int
    min_radius_kpc: float
    mesh_refine_factor: float
    mesh_max_rel_delta: float
    min_window_span_kpc: float
    tau_v_mape: float

def load_study_config(path: str) -> StudyConfig:
    with open(path, 'r') as f:
        y = yaml.safe_load(f)
    return StudyConfig(
        study_id=y['study_id'],
        size_rule=y['size_rule'],
        sizes_csv=y.get('sizes_csv', 'data/galaxy_sizes.csv'),
        mode=y['mode'],
        alphaP=float(y.get('alphaP', 0.0)),
        UGM_phys_m=float(y.get('UGM_phys_m', 0.0)),
        R_obs_m=float(y.get('R_obs_m', 0.0)),
        c_ms=float(y.get('c_ms', 299792458.0)),
        lambda_G_default=float(y.get('lambda_G_default', 1.0)),
        J_m2=float(y.get('J_m2', 0.0)),
        dvdr_max_kms_per_kpc=float(y['dvdr_max_kms_per_kpc']),
        min_window_points=int(y['min_window_points']),
        min_radius_kpc=float(y['min_radius_kpc']),
        mesh_refine_factor=float(y['mesh_refine_factor']),
        mesh_max_rel_delta=float(y['mesh_max_rel_delta']),
        min_window_span_kpc=float(y['min_window_span_kpc']),
        tau_v_mape=float(y['tau_v_mape']),
    )
